//*****************************************************************************
//
// Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/ 
// 
// staģʽ5socket磻3ÿ30sתsmartconfigģʽ
// APģʽ5socket¿APģʽ
//  Redistribution and use in source and binary forms, with or without 
//  modification, are permitted provided that the following conditions 
//  are met:
//MAP_UtilsDelay(8 000 000) = 8 000 000*6/8 000 000 = 0.6s =600ms
//    Redistributions of source code must retain the above copyright 
//    notice, this list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the 
//    documentation and/or other materials provided with the   
//    distribution.
//
//    Neither the name of Texas Instruments Incorporated nor the names of
//    its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************


//*****************************************************************************
//
// Application Name     - Getting started with WLAN AP
// Application Overview - This application aims to exhibit the CC3200 device as
//                        AP. Developers/users can refer the function or re-use 
//                        them while writing new application.
// Application Details  -
// http://processors.wiki.ti.com/index.php/CC32xx_Getting_Started_with_WLAN_AP
// or
// docs\examples\CC32xx_Getting_Started_with_WLAN_AP.pdf
//
//*****************************************************************************


//****************************************************************************
//
//! \addtogroup getting_started_ap
//! @{
//
//****************************************************************************

#include <stdlib.h>
#include <string.h>

// Simplelink includes
#include "simplelink.h"

// driverlib includes 
#include "hw_types.h"
#include "hw_ints.h"
#include "rom.h"
#include "rom_map.h"
#include "interrupt.h"
#include "prcm.h"
#include "utils.h"

#include "hw_memmap.h"
#include "uart.h"
//#include "nonos.h"
// free_rtos/ti-rtos includes 
#include "osi.h"
#include "gpio_if.h"
// common interface includes
#include "common.h"

#include "uart_if.h"

#include "pinmux.h"
#include "protocol.h"
#include "driver.h"

#include "wdt.h"
#include "wdt_if.h"

#include "timer.h"
#include "timer_if.h"

#include "shdata.h" 

#define APP_NAME                "SHUIXY UART WLAN AP"
#define APPLICATION_VERSION     "1.1.0"
#define OSI_STACK_SIZE          2048


#define WLAN_DEL_ALL_PROFILES   0xFF
// Values for below macros shall be modified for setting the 'Ping' properties
//
#define PING_INTERVAL       1000    /* In msecs */
#define PING_TIMEOUT        3000    /* In msecs */
#define PING_PKT_SIZE       20      /* In bytes */
#define NO_OF_ATTEMPTS      3
#define PING_FLAG           0
#define SH_GPIO_3                       (3)  /* P58 - Device Mode */

#define WD_PERIOD_MS                 1000   //1000msŹж
#define MAP_SysCtlClockGet           80000000
#define MILLISECONDS_TO_TICKS(ms)    ((MAP_SysCtlClockGet / 1000) * (ms))

#define read_device_status  10
#define control_device      20
#define CONSOLESH            UARTA1_BASE
#define UartGetChar()        MAP_UARTCharGet(CONSOLESH)
#define UartPutChar(c)       MAP_UARTCharPut(CONSOLESH,c)
#define UART_BAUD_RATE  9600//115200
#define SYSCLK          80000000
#define CONSOLE_PERIPHSH  PRCM_UARTA1

//*****************************************************************************
//                 GLOBAL VARIABLES -- Start
//*****************************************************************************
unsigned char ap_clienton = 0, ap_socketcnt = 0;
unsigned long uarn_cnt = 0,recib_cnt = 0;
unsigned char ap_ext =0,ap_ext_cnt = 0, socket_close_er = 0,home_cnt_10s = 0;
unsigned char test_data = 0,temp_jishucnt = 0;;
unsigned char uart1_2s_cnt = 0;
unsigned char uart1_flag = 0;
unsigned char control_bit_sh = 0; 
unsigned char heartbeat_send = 0;   //socketϱ־
unsigned char work_send_flag = 0;
unsigned char work_send_1m = 0;
unsigned char ap_sta_flag = 0;
unsigned char sh_seconds = 0;
unsigned char err_wait5s_flag = 0;
unsigned char err_loop_flag = 0;
unsigned char err_wait5s_cnt = 0;  //5뻹вȥͿŹλ
unsigned char error_cnt = 0; //ֻ¿ʼв㣬κδ󶼲
unsigned char heartbeat_11s = 0;
unsigned char shsta_bitcopy = 0;   //־
unsigned char  g_ulStatus = 0;
unsigned long  g_ulStaIp = 0;
unsigned char  stalink_cnt = 0;
unsigned char stalink_errcnt = 0;   //sta 330ûӳɹҪָµ
unsigned long  g_ulPingPacketsRecv = 0;
unsigned long  g_uiGatewayIP = 0;
unsigned char  g_ucConnectionSSID[SSID_LEN_MAX+1]; //Connection SSID
unsigned char  g_ucConnectionBSSID[BSSID_LEN_MAX]; //Connection BSSID
char* SHSSID_NAME = "chushihua_shangbuliaowang";
char* SHSECURITY_KEY = "buzhidao";
unsigned char SHSECURITY_TYPE = SL_SEC_TYPE_OPEN;
unsigned long  IP_ADDR = 0x65c87cfc;  // 101.200.124.252
//0x65c87cfc;  // 101.200.124.252
//0xc0a80169;//192.168.1.105
//0xa2f761ec;    //162.247.97.236
//0xc0a81564 ;  //192.168.21.100 ;
//0xc0a81565 ;  //192.168.21.101 ;
//0xc0a80ac2;     //192.168.10.194  
//0xc0a81564; //192.168.21.100
//0x0a26cbfa;  // 10.38.203.250  
//0XC0a82b01  192.168.43.1 
unsigned char  uart1_cnt = 0;
unsigned char uart1_err_cnt = 0;
unsigned long count_send = 0,count_recv = 0,jieshou_shpc_cnt = 0; 
unsigned int sh_set_timecp = 0;    //ϵ縴λĬϣ40ӣ2ػ״̬
unsigned char sh_set_powercp = 0;
unsigned char sh_set_onoffcp = 0;    //2----1
unsigned char sh_work_tempcp = 0;
unsigned int sh_work_continuetimecp = 0;
unsigned int sh_surplustimecp = 0;
//nonos
typedef _i8 _SHSlNonOsRetVal_t;
#define SHNONOS_RET_OK                            (0)
#define SHNONOS_MAX_SPAWN_ENTRIES		5
typedef struct
{
    _SlSpawnEntryFunc_t 		SHpEntry;
    void* 						SHpValue;
}_SHSlNonOsSpawnEntry_t;

typedef struct
{
    _SHSlNonOsSpawnEntry_t	SHSpawnEntries[SHNONOS_MAX_SPAWN_ENTRIES];
}_SHSlNonOsCB_t;

_SHSlNonOsCB_t SHg__SlNonOsCB;


////////////////////////
#if defined(gcc)
extern void (* const g_pfnVectors[])(void);
#endif
#if defined(ewarm)
extern uVectorEntry __vector_table;
#endif
//*****************************************************************************
//                 GLOBAL VARIABLES -- End
//*****************************************************************************



//****************************************************************************
//                      LOCAL FUNCTION PROTOTYPES
//****************************************************************************
static volatile unsigned long g_ulBase;
static volatile unsigned long g_ulRefBase;
//static int PingTest(unsigned long ulIpAddr);
static long ConfigureSimpleLinkToDefaultState();
static void InitializeAppVariables();
//static int GetSsidName(char *pcSsidName, unsigned int uiMaxLen);
int BsdTcpServer(unsigned short usPort);
int WuartTransfer(unsigned long ulBase, int iSockID);
#ifdef USE_FREERTOS
_SHSlNonOsRetVal_t _SHSlNonOsMainLoopTask(void)
{
    _i16 i;

    for (i=0 ; i<SHNONOS_MAX_SPAWN_ENTRIES ; i++)
    {
        _SHSlNonOsSpawnEntry_t* pE = &SHg__SlNonOsCB.SHSpawnEntries[i];
        _SlSpawnEntryFunc_t 		pF = pE->SHpEntry;

        if (NULL != pF)
        {
            if((g_pCB)->RxIrqCnt != (g_pCB)->RxDoneCnt)
            {
                pF(0);/*(pValue);*/
            }
            pE->SHpEntry = NULL;
            pE->SHpEntry = NULL;
        }
    }

    return SHNONOS_RET_OK;
}

//*****************************************************************************
// FreeRTOS User Hook Functions enabled in FreeRTOSConfig.h
//*****************************************************************************

//*****************************************************************************
//
//! \brief Application defined hook (or callback) function - assert
//!
//! \param[in]  pcFile - Pointer to the File Name
//! \param[in]  ulLine - Line Number
//! 
//! \return none
//!
//*****************************************************************************
void
vAssertCalled( const char *pcFile, unsigned long ulLine )
{
    //Handle Assert here
    while(1)
    {
    	err_loop_flag = 1;
    }
}
//*****************************************************************************
//
//! The interrupt handler for the first timer interrupt.
//!
//! \param  None
//!
//! \return none
//0.5s
//*****************************************************************************
void
TimerBaseIntHandler(void)
{

    // Clear the timer interrupt.
    //
    Timer_IF_InterruptClear(g_ulBase);
    //APģʽҳж,10.5sж
    if(shstatus_bit == 24)
    	{
    		heartbeat_11s = 0;work_send_flag = 0;work_send_1m = 0;
    		home_cnt_10s ++;
    		if(home_cnt_10s > 20)
    			{tcperror_cnt = 4;}
    	}
    else {home_cnt_10s = 0;}
    	
    //APģʽж
    if(ap_ext == 1)
    	{
    		ap_ext_cnt++;
    		if(ap_ext_cnt > 40) 
    			{
    				//err_loop_flag = 1;
    			}
    	}
    	else{ap_ext_cnt = 0;}
    //жuart1Ƿ񳬹6ûյ
    if(uart1_flag == 1)
    	{
    		uart1_2s_cnt++;
    		if( uart1_2s_cnt >12)
                {err_loop_flag = 1;}
    	}
   //ֻ͵Ĳжǲ3δ
    if((tcperror_cnt) && (tcperror_cnt < 4))
    	{
    		heartbeat_11s = 0;
    		three_seconds ++ ;
    		if(three_seconds == 6)
    			{
    				three_seconds = 0;
    				if(tcperror_cnt == 3)  //豸
    	      {
    		      //ʱպ豸ճɹ򲻸λȻ
    		      if((shstatus_bit == 6) ||(shstatus_bit == 18)||(shstatus_bit == 22))
  	 	        {
  	 		        tcperror_cnt = 0;
  	 	        }
    		      else {tcperror_cnt = 4;}
    	      }
    				//3sʱ䵽жĸ󣬲λ·ͻ
    				else if((shstatus_bit == 4)||(shstatus_bit == 5)) {shstatus_bit = 3;}
    				else if((shstatus_bit == 16)||(shstatus_bit == 17)) {shstatus_bit = 15;}
    			  else if((shstatus_bit == 20)||(shstatus_bit == 21)) {shstatus_bit = 19;}
    			}
    	}
    //ֻûдִУApģʽⲻͻ˵ߣҲûȨʱ
    //ĴSHmacַ鿴MACַǷעᣬ
    //ûעȨΪ1411עȷȨm,ȻͷSHMACַ
    //SHĴûעʱ֤ȨȷֻҪյӦ֤SOCKETûжϿ
    if(((sendrece_flag == 3) || (sendrece_flag == 4)|| (shstatus_bit == 3)) && (tcperror_cnt == 0))
    	{
    		heartbeat_11s ++;
    		if(heartbeat_11s == 22) 
    			{
            heartbeat_11s = 0;
            shstatus_bit = 19;   //һ              			
     			}
    	}
    else { heartbeat_11s = 0;}
    	
    if(shstatus_bit == 2)
    	{
    	 key_press_cnt ++;
    	}
    if ((key_press_cnt > 29 ) && (key_press_cnt < 35))
    	{
    		GPIO_IF_LedOff(MCU_ALL_LED_IND);key_press_cnt = 36;  // ͳһеƵ״̬
      }
    else if (key_press_cnt > 35 )
    	{
    			if(shstatus_bit > 2) //socketѾ
    					{GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);}
      	else {GPIO_IF_LedToggle(MCU_GREEN_LED_GPIO);}
      	GPIO_IF_LedToggle(MCU_RED_LED_GPIO);
        GPIO_IF_LedToggle(MCU_ORANGE_LED_GPIO);
    	}
 		else if (key_press_cnt > 19 )
    			{
    				GPIO_IF_LedOff(MCU_RED_LED_GPIO);GPIO_IF_LedOff(MCU_ORANGE_LED_GPIO);
    				if(shstatus_bit > 2) //socketѾ
    					{GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);
    						}
    				else if (ap_clienton == 1)
    					{
    						ap_socketcnt ++;
    						if(ap_socketcnt < 5)
    							{GPIO_IF_LedOn(MCU_GREEN_LED_GPIO);}
    						else 
    						{
    							GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
    							ap_socketcnt = 0;
    						}
    					}
    				else {GPIO_IF_LedToggle(MCU_GREEN_LED_GPIO);
    					}  //˸
    			}
    else if (key_press_cnt > 9 ) 
    			{
    				GPIO_IF_LedOff(MCU_ORANGE_LED_GPIO);GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
    				if(shstatus_bit > 2) //socketѾ
    					{GPIO_IF_LedOn(MCU_RED_LED_GPIO);
    						}
    				else {GPIO_IF_LedToggle(MCU_RED_LED_GPIO);
    					}  //˸
    			}
    else 
    	{
    		GPIO_IF_LedOff(MCU_RED_LED_GPIO);GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
    		if(shstatus_bit > 2) //socketѾ
    			{GPIO_IF_LedOn(MCU_ORANGE_LED_GPIO);
    				}
    	 else {GPIO_IF_LedToggle(MCU_ORANGE_LED_GPIO);
    	 	}  //˸
    	}
    if(stalink_cnt < 61) {stalink_cnt ++ ;}  //30ϱ
    if(err_wait5s_flag == 2 ) 
    	{
    		err_wait5s_cnt ++ ;
    		if(err_wait5s_cnt > 9) 
    			{
    				err_loop_flag = 1;   //5뻹ûִ꣬Źλִ
    			}
    	}  //ĳһγʼִУ5ǲִ
    if (err_loop_flag == 0 )  //ûеȴʱ־㿴ŹˣҪλ
    	{
    		//㿴Ź
    		//MAP_WatchdogIntClear(WDT_BASE);
    	}	    	
  
     	//1Ӷһ豸״̬
     	 if(work_send_flag == 1) 
     	 	{
     	 		work_send_1m ++;
     	 		if(work_send_1m > 1)  //2*0.5s=1sһ
     	 			{ 
     	 				//ˢݡ豸豸ݡɹñ־
     	 				if((shstatus_bit == 12) ||\
     	 					(shstatus_bit == 14) ||(shstatus_bit == 18) ||\
     	 					(shstatus_bit == 22))
     	 					{
     	 						work_send_flag = 2;
     	 					}   //·һ豸
     	 			}
     	 	}
}
//*****************************************************************************
//
//! The interrupt handler for the second timer interrupt.
//!
//! \param  None
//!
//! \return none
//0.25s
//*****************************************************************************
void
TimerRefIntHandler(void)
{
    //
    // Clear the timer interrupt.
    //
    if (err_loop_flag == 0 )  //ûеȴʱ־㿴ŹˣҪλ
    	{
    		//㿴Ź
    		//MAP_WatchdogIntClear(WDT_BASE);
    	}	    	
    Timer_IF_InterruptClear(g_ulRefBase);
}

//ȡ
static void ReadDeviceConfiguration()
{ 
	  unsigned char  KEY_GPIO_03_PIN_58 = 0;
    unsigned int uiGPIOPort;
    unsigned char pucGPIOPin;
    key_press_cnt = 0;
        //Read GPIO
     GPIO_IF_GetPortNPin(SH_GPIO_3,&uiGPIOPort,&pucGPIOPin);
     KEY_GPIO_03_PIN_58 = GPIO_IF_Get(SH_GPIO_3,uiGPIOPort,pucGPIOPin);
     while(KEY_GPIO_03_PIN_58 == 1) 
    {
    	 KEY_GPIO_03_PIN_58 = GPIO_IF_Get(SH_GPIO_3,uiGPIOPort,pucGPIOPin);
       if (key_press_cnt > 30)
       	{KEY_GPIO_03_PIN_58 = 0;}
    }
 }

//*****************************************************************************
//
//! \brief Application defined idle task hook
//! 
//! \param  none
//! 
//! \return none
//!
//*****************************************************************************
void
vApplicationIdleHook( void)
{
    //Handle Idle Hook for Profiling, Power Management etc
}

//*****************************************************************************
//
//! \brief Application defined malloc failed hook
//! 
//! \param  none
//! 
//! \return none
//!
//*****************************************************************************
void vApplicationMallocFailedHook()
{
    //Handle Memory Allocation Errors
    while(1)
    {
    	err_loop_flag = 1;
    }
}

//*****************************************************************************
//
//! \brief Application defined stack overflow hook
//! 
//! \param  none
//! 
//! \return none
//!
//*****************************************************************************
void vApplicationStackOverflowHook(OsiTaskHandle *pxTask, 
                                   signed char *pcTaskName)
{
    //Handle FreeRTOS Stack Overflow
    while(1)
    {
    	err_loop_flag = 1;
    }
}
#endif //USE_FREERTOS


//*****************************************************************************
// SimpleLink Asynchronous Event Handlers -- Start
//*****************************************************************************


//*****************************************************************************
//
//! On Successful completion of Wlan Connect, This function triggers Connection
//! status to be set. 
//!
//! \param  pSlWlanEvent pointer indicating Event type
//!
//! \return None
//!
//*****************************************************************************
void SimpleLinkWlanEventHandler(SlWlanEvent_t *pSlWlanEvent)
{
    switch(pSlWlanEvent->Event)
    {
        case SL_WLAN_CONNECT_EVENT:
        {
            SET_STATUS_BIT(g_ulStatus, STATUS_BIT_CONNECTION);

            //
            // Information about the connected AP (like name, MAC etc) will be
            // available in 'slWlanConnectAsyncResponse_t'-Applications
            // can use it if required
            //
            //  slWlanConnectAsyncResponse_t *pEventData = NULL;
            // pEventData = &pWlanEvent->EventData.STAandP2PModeWlanConnected;
            //
            // Copy new connection SSID and BSSID to global parameters
            memcpy(g_ucConnectionSSID,pSlWlanEvent->EventData.
                   STAandP2PModeWlanConnected.ssid_name,
                   pSlWlanEvent->EventData.STAandP2PModeWlanConnected.ssid_len);
            memcpy(g_ucConnectionBSSID,
                   pSlWlanEvent->EventData.STAandP2PModeWlanConnected.bssid,
                   SL_BSSID_LENGTH);

            UART_PRINT("shuixy[WLAN EVENT] STA Connected to the AP: %s ,"
                        "BSSID: %x:%x:%x:%x:%x:%x\n\r",
                      g_ucConnectionSSID,g_ucConnectionBSSID[0],
                      g_ucConnectionBSSID[1],g_ucConnectionBSSID[2],
                      g_ucConnectionBSSID[3],g_ucConnectionBSSID[4],
                      g_ucConnectionBSSID[5]);
        }
        break;

        case SL_WLAN_DISCONNECT_EVENT:
        {
            slWlanConnectAsyncResponse_t*  pEventData = NULL;

            CLR_STATUS_BIT(g_ulStatus, STATUS_BIT_CONNECTION);
            CLR_STATUS_BIT(g_ulStatus, STATUS_BIT_IP_AQUIRED);

            pEventData = &pSlWlanEvent->EventData.STAandP2PModeDisconnected;

            // If the user has initiated 'Disconnect' request,
            //'reason_code' is SL_USER_INITIATED_DISCONNECTION
            if(SL_USER_INITIATED_DISCONNECTION == pEventData->reason_code)
            {
                UART_PRINT("[WLAN EVENT]Device disconnected from the AP: %s,"
                "BSSID: %x:%x:%x:%x:%x:%x on application's request \n\r",
                           g_ucConnectionSSID,g_ucConnectionBSSID[0],
                           g_ucConnectionBSSID[1],g_ucConnectionBSSID[2],
                           g_ucConnectionBSSID[3],g_ucConnectionBSSID[4],
                           g_ucConnectionBSSID[5]);
            }
            else    //ˣ豸
            {
                UART_PRINT("[WLAN ERROR]Device disconnected from the AP AP: %s,"
                "BSSID: %x:%x:%x:%x:%x:%x on an ERROR..!! \n\r",
                           g_ucConnectionSSID,g_ucConnectionBSSID[0],
                           g_ucConnectionBSSID[1],g_ucConnectionBSSID[2],
                           g_ucConnectionBSSID[3],g_ucConnectionBSSID[4],
                           g_ucConnectionBSSID[5]);
                ap_sta_flag = 2;
            }
            memset(g_ucConnectionSSID,0,sizeof(g_ucConnectionSSID));
            memset(g_ucConnectionBSSID,0,sizeof(g_ucConnectionBSSID));
        }
        break;
       case SL_WLAN_SMART_CONFIG_COMPLETE_EVENT:   //smartconfig óɹ
        {
            SET_STATUS_BIT(g_ulStatus, STATUS_BIT_SMARTCONFIG_START); //g_ulStatus =0x10

            //
            // Information about the SmartConfig details (like Status, SSID, 
            // Token etc) will be available in 'slSmartConfigStartAsyncResponse_t' 
            // - Applications can use it if required
            //
            //  slSmartConfigStartAsyncResponse_t *pEventData = NULL;
             // pEventData = &pSlWlanEvent->EventData.smartConfigStartResponse;
             
            UART_PRINT("WLAN_SMART_CONFIG_COMPLETE_EVENT is start and ap_sta_flag = %x!!!\n\r",g_ulStatus );

        }
        break;

        case SL_WLAN_SMART_CONFIG_STOP_EVENT:      //smartconfig 
        {
            // SmartConfig operation finished
            CLR_STATUS_BIT(g_ulStatus, STATUS_BIT_SMARTCONFIG_START);

            //
            // Information about the SmartConfig details (like Status, padding 
            // etc) will be available in 'slSmartConfigStopAsyncResponse_t' - 
            // Applications can use it if required
            //
            // slSmartConfigStopAsyncResponse_t *pEventData = NULL;
            // pEventData = &pSlWlanEvent->EventData.smartConfigStopResponse;
            //
        }
        break;
        case SL_WLAN_STA_CONNECTED_EVENT:
        {
            // when device is in AP mode and any client connects to device cc3xxx
            SET_STATUS_BIT(g_ulStatus, STATUS_BIT_CONNECTION);

            //
            // Information about the connected client (like SSID, MAC etc) will be
            // available in 'slPeerInfoAsyncResponse_t' - Applications
            // can use it if required
            //
            // slPeerInfoAsyncResponse_t *pEventData = NULL;
            // pEventData = &pSlWlanEvent->EventData.APModeStaConnected;
            //
           

            UART_PRINT("[WLAN EVENT] STA is connected to the AP is ok!!!\n\r");
                     
        }
        break;

        case SL_WLAN_STA_DISCONNECTED_EVENT:     //豸APģʽʱ⵽ͻ˴豸ӶϿ
        {
            // when client disconnects from device (AP)
            CLR_STATUS_BIT(g_ulStatus, STATUS_BIT_CONNECTION);
            CLR_STATUS_BIT(g_ulStatus, STATUS_BIT_IP_LEASED);
            ap_sta_flag = 1;
            //
            // Information about the connected client (like SSID, MAC etc) will
            // be available in 'slPeerInfoAsyncResponse_t' - Applications
            // can use it if required
            //
            // slPeerInfoAsyncResponse_t *pEventData = NULL;
            // pEventData = &pSlWlanEvent->EventData.APModestaDisconnected;
            //            
        }
        break;

        default:
        {
            UART_PRINT("[WLAN EVENT] Unexpected event WLAN event is--%x\n\r",pSlWlanEvent->Event);
        }
        break;
    } 
}
//*****************************************************************************
//
//! \brief Connecting to a WLAN Accesspoint using SmartConfig provisioning
//!
//! Enables SmartConfig provisioning for adding a new connection profile
//! to CC3200. Since we have set the connection policy to Auto, once
//! SmartConfig is complete, CC3200 will connect automatically to the new
//! connection profile added by smartConfig.
//!
//! \param[in]                     None
//!
//! \return                        None
//!
//! \note
//!
//! \warning                    If the WLAN connection fails or we don't
//!                             acquire an IP address, We will be stuck in this
//!                             function forever.
//
//*****************************************************************************
int SmartConfigConnect()
{
    unsigned char policyVal;
    long lRetVal = -1;

    // Clear all profiles 
    // This is of course not a must, it is used in this example to make sure
    // we will connect to the new profile added by SmartConfig
   
    //
    if(key_press_cnt > 9)   //ָµ
    	{
     	  UART_PRINT("\r\nPlease set new ssid and password\n\r");
    	  lRetVal = sl_WlanProfileDel(WLAN_DEL_ALL_PROFILES);
    	  ASSERT_ON_ERROR(lRetVal);

   		   //set AUTO policy
    	  lRetVal = sl_WlanPolicySet(  SL_POLICY_CONNECTION,
                      SL_CONNECTION_POLICY(1,0,0,0,1),
                      &policyVal,
                      1 /*PolicyValLen*/);
    	  ASSERT_ON_ERROR(lRetVal);

    	   // Start SmartConfig
    	   // This example uses the unsecured SmartConfig method
     		 lRetVal = sl_WlanSmartConfigStart(0,                /*groupIdBitmask*/
                           SMART_CONFIG_CIPHER_NONE,    /*cipher*/
                           0,                           /*publicKeyLen*/
                           0,                           /*group1KeyLen*/
                           0,                           /*group2KeyLen */
                           NULL,                        /*publicKey */
                           NULL,                        /*group1Key */
                           NULL);                       /*group2Key*/
           ASSERT_ON_ERROR(lRetVal);
      }
     // Wait for WLAN Event
    stalink_cnt = 0;  
    while((!IS_CONNECTED(g_ulStatus)) || (!IS_IP_ACQUIRED(g_ulStatus)))
    {
        _SHSlNonOsMainLoopTask();
        if (stalink_cnt > 60)   //Ӿ30ûϳ2ΣָµҪsmartconfigʼ30s*2λûϣ
        	{
        		ap_sta_flag = 2; stalink_cnt = 0;
        		stalink_errcnt ++ ;
        		if(stalink_errcnt > 1)
        			{key_press_cnt = 11;stalink_errcnt = 0;ASSERT_ON_ERROR(-1); }        		
        	}
    }
    ap_sta_flag = 0; stalink_errcnt = 0;stalink_cnt = 0;  
    key_press_cnt = 5;      //Ѿָµӣ´Զ,Ź쳣λֱ磬smartconfig
    if(status_system[1] != 1) //óɹ־
     {
       status_system[1] = 1; 
       if(WriteFileToDevice(&lFileHandle) < 0)
         {
            ASSERT_ON_ERROR(-1); 
         }
     }  
     //
     // Turn ON the RED LED to indicate connection success
     //
      //wait for few moments
     MAP_UtilsDelay(80000000);
     //reset to default AUTO policy
     lRetVal = sl_WlanPolicySet(  SL_POLICY_CONNECTION,
                           SL_CONNECTION_POLICY(1,0,0,0,0),
                           &policyVal,
                           1 /*PolicyValLen*/);
     ASSERT_ON_ERROR(lRetVal);
    return SUCCESS;
}
//*****************************************************************************
//
//! \brief This function handles network events such as IP acquisition, IP
//!           leased, IP released etc.
//!
//! \param[in]  pNetAppEvent - Pointer to NetApp Event Info 
//!
//! \return None
//!
//*****************************************************************************
void SimpleLinkNetAppEventHandler(SlNetAppEvent_t *pNetAppEvent)
{
    switch(pNetAppEvent->Event)
    {
        case SL_NETAPP_IPV4_IPACQUIRED_EVENT:  //ӡIPַΪAPģʽĵַΪSTAģʽʱwifi·õIP
        	{
        		 UART_PRINT("[NETAPP EVENT] SH's IP Acquired adress: IP=%d.%d.%d.%d , "
            "Gateway=%d.%d.%d.%d\n\r", 
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.ip,3),
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.ip,2),
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.ip,1),
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.ip,0),
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.gateway,3),
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.gateway,2),
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.gateway,1),
            SL_IPV4_BYTE(pNetAppEvent->EventData.ipAcquiredV4.gateway,0));
        	}
        case SL_NETAPP_IPV6_IPACQUIRED_EVENT:
        {
            SET_STATUS_BIT(g_ulStatus, STATUS_BIT_IP_AQUIRED);
        }
        break;
        
        case SL_NETAPP_IP_LEASED_EVENT:   //IPõĵַ ӵģĿͻ˵ַ
        {
            SET_STATUS_BIT(g_ulStatus, STATUS_BIT_IP_LEASED);
        
            g_ulStaIp = (pNetAppEvent)->EventData.ipLeased.ip_address;
            
            UART_PRINT("[NETAPP EVENT] IP Leased to Client: IP=%d.%d.%d.%d , ",
                        SL_IPV4_BYTE(g_ulStaIp,3), SL_IPV4_BYTE(g_ulStaIp,2),
                        SL_IPV4_BYTE(g_ulStaIp,1), SL_IPV4_BYTE(g_ulStaIp,0));
        }
        break;
        
        case SL_NETAPP_IP_RELEASED_EVENT:   //ͷŵĿͻ˵ַ
        {
            CLR_STATUS_BIT(g_ulStatus, STATUS_BIT_IP_LEASED);

            UART_PRINT("[NETAPP EVENT] IP Released to Client: IP=%d.%d.%d.%d , ",
                        SL_IPV4_BYTE(g_ulStaIp,3), SL_IPV4_BYTE(g_ulStaIp,2),
                        SL_IPV4_BYTE(g_ulStaIp,1), SL_IPV4_BYTE(g_ulStaIp,0));

        }
        break;

        default:
        {
            UART_PRINT("[NETAPP EVENT] Unexpected event [0x%x] \n\r",
                       pNetAppEvent->Event);
        }
        break;
    }
}


//*****************************************************************************
//
//! \brief This function handles HTTP server events
//!
//! \param[in]  pServerEvent - Contains the relevant event information
//! \param[in]    pServerResponse - Should be filled by the user with the
//!                                      relevant response information
//!
//! \return None
//!
//****************************************************************************
void SimpleLinkHttpServerCallback(SlHttpServerEvent_t *pHttpEvent,
                                  SlHttpServerResponse_t *pHttpResponse)
{
    // Unused in this application
}

//*****************************************************************************
//
//! \brief This function handles General Events
//!
//! \param[in]     pDevEvent - Pointer to General Event Info 
//!
//! \return None
//!
//*****************************************************************************
void SimpleLinkGeneralEventHandler(SlDeviceEvent_t *pDevEvent)
{
    //
    // Most of the general errors are not FATAL are are to be handled
    // appropriately by the application
    //
    UART_PRINT("[GENERAL EVENT] - ID=[%d] Sender=[%d]\n\n",
               pDevEvent->EventData.deviceEvent.status, 
               pDevEvent->EventData.deviceEvent.sender);
}


//*****************************************************************************
//
//! This function handles socket events indication
//!
//! \param[in]      pSock - Pointer to Socket Event Info
//!
//! \return None
//!
//*****************************************************************************
void SimpleLinkSockEventHandler(SlSockEvent_t *pSock)
{
    //
    // This application doesn't work w/ socket - Events are not expected
    //
       switch( pSock->Event )
    {
        case SL_SOCKET_TX_FAILED_EVENT:
            switch( pSock->EventData.status )
            {
                case SL_ECLOSE: 
                	  socket_close_er = 1;
                    UART_PRINT("[SOCK ERROR] - close socket (%d) operation "
                                "failed to transmit all queued packets\n\n", 
                                pSock->EventData.sd);
                    break;
                default: 
                    UART_PRINT("[SOCK ERROR] - TX FAILED : socket %d , reason"
                                "(%d) \n\n",
                                pSock->EventData.sd, pSock->EventData.status);
            }
            break;
      //  case SL_SOCKET_ASYNC_EVENT:
       //      break;
      //  case SL_ECLOSE:
       //      break; 
        default:
          UART_PRINT("[SOCK EVENT] - Unexpected Event [%x0x]\n\n",pSock->Event);
    }
}

//*****************************************************************************
//
//! \brief This function handles ping report events
//!
//! \param[in]     pPingReport - Ping report statistics
//!
//! \return None
//
//****************************************************************************
void SimpleLinkPingReport(SlPingReport_t *pPingReport)
{
    SET_STATUS_BIT(g_ulStatus, STATUS_BIT_PING_DONE);
    g_ulPingPacketsRecv = pPingReport->PacketsReceived;
}


//*****************************************************************************
// SimpleLink Asynchronous Event Handlers -- End
//*****************************************************************************


//****************************************************************************
//
//!    \brief This function initializes the application variables
//!
//!    \param[in]  None
//!
//!    \return     None
//
//****************************************************************************
static void InitializeAppVariables()
{
    g_ulStatus = 0;
    g_ulStaIp = 0;
    g_ulPingPacketsRecv = 0;
    g_uiGatewayIP = 0;
    memset(g_ucConnectionSSID,0,sizeof(g_ucConnectionSSID));
    memset(g_ucConnectionBSSID,0,sizeof(g_ucConnectionBSSID));
}

//*****************************************************************************
//! \brief This function puts the device in its default state. It:
//!           - Set the mode to STATION
//!           - Configures connection policy to Auto and AutoSmartConfig
//!           - Deletes all the stored profiles
//!           - Enables DHCP
//!           - Disables Scan policy
//!           - Sets Tx power to maximum
//!           - Sets power policy to normal
//!           - Unregister mDNS services
//!           - Remove all filters
//!
//! \param   none
//! \return  On success, zero is returned. On error, negative is returned
//*****************************************************************************
static long ConfigureSimpleLinkToDefaultState()
{
    SlVersionFull   ver = {0};
    _WlanRxFilterOperationCommandBuff_t  RxFilterIdMask = {0};
   unsigned char Sh_pConfigLen = SL_BSSID_LENGTH;    //SL_BSSID_LENGTHnetcfg.hж	

    unsigned char ucVal = 1;
    unsigned char ucConfigOpt = 0;
    unsigned char ucConfigLen = 0;
    unsigned char ucPower = 0;
    long lRetVal = -1;
    long lMode = -1;
    shstatus_bit = 0;  // ݴӳִ̣λ0
    uart1_flag = 0;
    lMode = sl_Start(0, 0, 0); 
    ASSERT_ON_ERROR(lMode);

    // If the device is not in station-mode, try configuring it in station-mode 
    if (ROLE_STA != lMode)
    {
        if (ROLE_AP == lMode)
        {
            // If the device is in AP mode, we need to wait for this event 
            // before doing anything 
            while(!IS_IP_ACQUIRED(g_ulStatus))
            {
//#ifndef SL_PLATFORM_MULTI_THREADED
              if(key_press_cnt < 20)
               { _SHSlNonOsMainLoopTask(); } 
            }
        }

        // Switch to STA role and restart 
        lRetVal = sl_WlanSetMode(ROLE_STA);
        ASSERT_ON_ERROR(lRetVal);

        lRetVal = sl_Stop(0xFF);
        ASSERT_ON_ERROR(lRetVal);

        lRetVal = sl_Start(0, 0, 0);
        ASSERT_ON_ERROR(lRetVal);

        // Check if the device is in station again 
        if (ROLE_STA != lRetVal)
        {
            // We don't want to proceed if the device is not coming up in STA-mode 
            return DEVICE_NOT_IN_STATION_MODE;
        }
    }
    
    // Get the device's version-information
    ucConfigOpt = SL_DEVICE_GENERAL_VERSION;
    ucConfigLen = sizeof(ver);
    lRetVal = sl_DevGet(SL_DEVICE_GENERAL_CONFIGURATION, &ucConfigOpt, 
                                &ucConfigLen, (unsigned char *)(&ver));
    ASSERT_ON_ERROR(lRetVal);
    
    UART_PRINT("Host Driver Version: %s\n\r",SL_DRIVER_VERSION);
    UART_PRINT("Build Version %d.%d.%d.%d.31.%d.%d.%d.%d.%d.%d.%d.%d\n\r",
    ver.NwpVersion[0],ver.NwpVersion[1],ver.NwpVersion[2],ver.NwpVersion[3],
    ver.ChipFwAndPhyVersion.FwVersion[0],ver.ChipFwAndPhyVersion.FwVersion[1],
    ver.ChipFwAndPhyVersion.FwVersion[2],ver.ChipFwAndPhyVersion.FwVersion[3],
    ver.ChipFwAndPhyVersion.PhyVersion[0],ver.ChipFwAndPhyVersion.PhyVersion[1],
    ver.ChipFwAndPhyVersion.PhyVersion[2],ver.ChipFwAndPhyVersion.PhyVersion[3]);

    // Set connection policy to Auto + SmartConfig 
    //      (Device's default connection policy)
    lRetVal = sl_WlanPolicySet(SL_POLICY_CONNECTION, 
                                SL_CONNECTION_POLICY(1, 0, 0, 0, 1), NULL, 0);
    ASSERT_ON_ERROR(lRetVal);
     //ûȨԶAPģʽ
    //ѾȨ䶯STAҲAPģʽ
    //STAģʽûsmartconfigɹsmartconfigģʽ
    //Ѿsmartconfigɹ䶯ûѡϴεãҲѡ
  if(ReadFileFromDevice(lFileHandle) < 0)
    {
      memset(status_system,0,SL_MAX_FILE_SIZE);
      if(WriteFileToDevice(&lFileHandle) < 0)
         {
           ASSERT_ON_ERROR(-1);
          }
    }
 if(authoreze_flag == 1) { status_system[0] = 0;}
  //ݵǰ豸ǷȨǷжָʱ䣨ûûȷϵͳٴѭʱִеģ
  if(status_system[0]!= 1)  //ûȨԶAPģʽ
  	{key_press_cnt = 31;}  
  	//ѾȨSTAģʽжǷ磬ûsmartģʽsmartɹkey_press_cnt = 50
  else if((key_press_cnt < 20)&&(status_system[1]!= 1))//STAģʽûûѡָ磬ûsmartconfigɹsmartconfigģʽ
  	{key_press_cnt = 11;}
 //STAģʽҲµӣָ磬ɾ
    if(key_press_cnt < 10)
    	{
    	  UART_PRINT("\r\nSH is STA mode and connect old wifi,please waitting....!\n\r");       
      }
    else if(key_press_cnt < 20) //ָµ
    	{
    	  UART_PRINT("Remove all profiles........................");
    		// Remove all profiles
        lRetVal = sl_WlanProfileDel(0xFF);
        ASSERT_ON_ERROR(lRetVal);
        UART_PRINT("\r\nSH is STA mode and connect a new wifi  new  wifi !\n\r"); 
    	}
   else if(key_press_cnt < 30)   //key_press_cnt > 1000  APģʽ
    {
    	 //status_system[0]= 0;    //ȡȨ־
    	 UART_PRINT("\r\n SH is Configure to AP mode!\n\r");
    }
   else //15sϣȨģʽ
   {
   	  status_system[0]= 0;    //ȡȨ־
   	  key_press_cnt = 31;
    	UART_PRINT("\r\n SH is Configure to authorize Ap mode!\n\r");
   }
   //ȡMACַɹ
	 sl_NetCfgGet(SL_MAC_ADDRESS_GET, NULL,&Sh_pConfigLen, Sh_pMacAddress); //SL_MAC_ADDRESS_GETnetcfg.hжΪ2
	 UART_PRINT("shuixy BSSID: %x:%x:%x:%x:%x:%x\n\r",
                      (unsigned char)Sh_pMacAddress[0],
                      (unsigned char)Sh_pMacAddress[1],(unsigned char)Sh_pMacAddress[2],
                      (unsigned char)Sh_pMacAddress[3],(unsigned char)Sh_pMacAddress[4],
                      (unsigned char)Sh_pMacAddress[5]);
    //
    // Device in station-mode. Disconnect previous connection if any
    // The function returns 0 if 'Disconnected done', negative number if already
    // disconnected Wait for 'disconnection' event if 0 is returned, Ignore 
    // other return-codes
    //
    lRetVal = sl_WlanDisconnect();
    if(0 == lRetVal)
    {
        // Wait
        while(IS_CONNECTED(g_ulStatus))
        {
          if(key_press_cnt < 20)
               { _SHSlNonOsMainLoopTask(); } 
        }
    }

    // Enable DHCP client
    lRetVal = sl_NetCfgSet(SL_IPV4_STA_P2P_CL_DHCP_ENABLE,1,1,&ucVal);
    ASSERT_ON_ERROR(lRetVal);

    // Disable scan
    ucConfigOpt = SL_SCAN_POLICY(0);
    lRetVal = sl_WlanPolicySet(SL_POLICY_SCAN , ucConfigOpt, NULL, 0);
    ASSERT_ON_ERROR(lRetVal);

    // Set Tx power level for station mode
    // Number between 0-15, as dB offset from max power - 0 will set max power
    ucPower = 0;
    lRetVal = sl_WlanSet(SL_WLAN_CFG_GENERAL_PARAM_ID, 
            WLAN_GENERAL_PARAM_OPT_STA_TX_POWER, 1, (unsigned char *)&ucPower);
    ASSERT_ON_ERROR(lRetVal);

    // Set PM policy to normal
    lRetVal = sl_WlanPolicySet(SL_POLICY_PM , SL_NORMAL_POLICY, NULL, 0);
    ASSERT_ON_ERROR(lRetVal);

    // Unregister mDNS services
    lRetVal = sl_NetAppMDNSUnRegisterService(0, 0);
    ASSERT_ON_ERROR(lRetVal);

    // Remove  all 64 filters (8*8) 
    memset(RxFilterIdMask.FilterIdMask, 0xFF, 8);
    lRetVal = sl_WlanRxFilterSet(SL_REMOVE_RX_FILTER, (_u8 *)&RxFilterIdMask,
                       sizeof(_WlanRxFilterOperationCommandBuff_t));
    ASSERT_ON_ERROR(lRetVal);

    lRetVal = sl_Stop(SL_STOP_TIMEOUT);
    ASSERT_ON_ERROR(lRetVal);

    InitializeAppVariables();
    
    return lRetVal; // Success
}



//****************************************************************************
//
//! Confgiures the mode in which the device will work
//!
//! \param iMode is the current mode of the device
//!
//! This function
//!    1. prompt user for desired configuration and accordingly configure the
//!          networking mode(STA or AP).
//ʾúӦģʽûSTAAP
//!       2. also give the user the option to configure the ssid name in case of
//!       AP mode.
//!ҲûAPģʽSSID
//! \return sl_start return value(int).
// Ҫû뱾ģAPP
//****************************************************************************
static int ConfigureMode(int iMode)
{
    //char    pcSsidName[33];
    char    pcSsidName[33] = "Open_ZL";
    long    lRetVal = -1;
    char    pckeyName[13] = "zhoulingongsi";
    //UART_PRINT("Enter the AP SSID name: ");
    //GetSsidName(pcSsidName,33);
    _u8  val = SL_SEC_TYPE_WPA_WPA2; 
    lRetVal = sl_WlanSetMode(ROLE_AP);
    ASSERT_ON_ERROR(lRetVal);

    lRetVal = sl_WlanSet(SL_WLAN_CFG_AP_ID, WLAN_AP_OPT_SSID, strlen(pcSsidName),
                            (unsigned char*)pcSsidName);
    ASSERT_ON_ERROR(lRetVal);
    lRetVal = sl_WlanSet(SL_WLAN_CFG_AP_ID, WLAN_AP_OPT_SECURITY_TYPE, 1, (_u8 *)&val);
    ASSERT_ON_ERROR(lRetVal);
    lRetVal = sl_WlanSet(SL_WLAN_CFG_AP_ID, WLAN_AP_OPT_PASSWORD, strlen(pckeyName),
                            (unsigned char*)pckeyName);
    ASSERT_ON_ERROR(lRetVal);
    UART_PRINT("Device is configured in AP mode,SSID is:%s  KEY is:%s\n\r",pcSsidName,pckeyName);

    /* Restart Network processor */
    lRetVal = sl_Stop(SL_STOP_TIMEOUT);

    // reset status bits
    CLR_STATUS_BIT_ALL(g_ulStatus);

    return sl_Start(NULL,NULL,NULL);
}

//****************************************************************************
//ӴڻûSSID
//! Get Ssid name form the user over UART
//!
//! \param pcSsidName is a pointer to the array which will contain the ssid name
//!
//! This function
//!    1. gets the ssid name string over uart
//!
//! \return iRetVal is the length of the ssid(user input).
//
//****************************************************************************
/*
static int GetSsidName(char *pcSsidName, unsigned int uiMaxLen)
{
  char ucRecvdAPDetails = 0;
  int  iRetVal = 0;
  char acCmdStore[128];
  do
  {
      ucRecvdAPDetails = 0;

      //
      // Get the AP name to connect over the UART
      //
      iRetVal = GetCmd(acCmdStore, sizeof(acCmdStore));
      if(iRetVal > 0)
      {
          // remove start/end spaces if any
          iRetVal = TrimSpace(acCmdStore);

          //
          // Parse the AP name
          //
          strncpy(pcSsidName, acCmdStore, iRetVal);
          if(pcSsidName != NULL)
          {
              ucRecvdAPDetails = 1;
              pcSsidName[iRetVal] = '\0';
          }
      }
  }while(ucRecvdAPDetails == 0);

  return(iRetVal);
}
*/
//****************************************************************************
//
//!    \brief device will try to ping the machine that has just connected to the
//!           device.
//!
//!    \param  ulIpAddr is the ip address of the station which has connected to
//!            device
//!
//!    \return 0 if ping is successful, -1 for error
//
//****************************************************************************
/*
static int PingTest(unsigned long ulIpAddr)
{  
    signed long           lRetVal = -1;
    SlPingStartCommand_t PingParams;
    SlPingReport_t PingReport;
    PingParams.PingIntervalTime = PING_INTERVAL;
    PingParams.PingSize = PING_PKT_SIZE;
    PingParams.PingRequestTimeout = PING_TIMEOUT;
    PingParams.TotalNumberOfAttempts = NO_OF_ATTEMPTS;
    PingParams.Flags = PING_FLAG;
    PingParams.Ip = ulIpAddr; // Cleint's ip address /
    
    UART_PRINT("Running Ping Test...\n\r");
    // Check for LAN connection /
    lRetVal = sl_NetAppPingStart((SlPingStartCommand_t*)&PingParams, SL_AF_INET,
                            (SlPingReport_t*)&PingReport, NULL);
    ASSERT_ON_ERROR(lRetVal);

    g_ulPingPacketsRecv = PingReport.PacketsReceived;

    if (g_ulPingPacketsRecv > 0 && g_ulPingPacketsRecv <= NO_OF_ATTEMPTS)
    {
      // LAN connection is successful
      UART_PRINT("Ping Test successful\n\r");
    }
    else
    {
        // Problem with LAN connection
        ASSERT_ON_ERROR(LAN_CONNECTION_FAILED);
    }

    return SUCCESS;
}
*/
////////////////////////ӡͺͽϢ////////////////////////////
void print_dataarray(char *goadress,unsigned char count,unsigned char seorr)
{
	unsigned char i;
  
  for(i=0;i<count;i++)
  {
  	if(i == 0)
  	{
  		if(seorr == 0)
  		  {UART_PRINT("\r\nSEND-DATA IS: %x",*goadress);}
  		else
  			{UART_PRINT("\r\nRECIVE-DATA IS: %x",*goadress);}
  	}
  	else 
  	{
  		UART_PRINT(" %x",*(goadress+i));
  	}
  }
  UART_PRINT(" Data count=%d\n\r",count);

}
// uart1豸ͨѶ豸//////////////////////// 
//ʣ9600
//7b 3f 00 00(2ֽʱ) 00-1ֽڵλ  00--״̬ 00-- 7d
// 豸Ӧ ɹ-7b 3f 3f 3f 3f 3f 3f 7d  ʧ-7b 3e 3e 3e 3e 3e 3e 7d
//豸״̬ 7b 3c 3c 3c 3c 3c 3c 7d
//    豸Ӧɹ10ֽ--7b 3d 00 00(2ֽڹʱ) 00 002ֽʣʱ䣩00-λ 00- 00-¶ 7d
//ʧܣʧ-7b 3e 3e 3e 3e 3e 3e 7d ģ鷢һûյЧķأ3ŷͣ3ûзϿsocketӣȴҵ豸socket
void shuart1_control( unsigned char read_control)
{
	 //˺豸ҪԼ    //豸ԺҪȶ豸״̬
	//ˣ豸ͶϢ豸Լƣģ鲻ʱֱ豸ٿ豸
	
	//豸״̬ǰȶ豸״̬趨ʱ䡢ǰʱ䡢λ¶ȡǰ״̬
	//豸ߣյsocket4豸ΪֻݣҼʱ豸
	  unsigned char uart1_error_cnt;
		unsigned char cCharacter[10];
		unsigned char com_data_control[8];
		uart1_2s_cnt = 0;uart1_flag = 0; 
    memset(com_data_control+1,0x3f,6); 
    com_data_control[0]=0x7b;
    com_data_control[7]=0x7d;
		uart1_err_cnt = 0;
		sh_sucfail = 1;
	  uart1_2s_cnt = 0;uart1_flag = 1;
	switch(read_control)
	{
		
		case read_device_status:    //豸״̬
			   while(uart1_err_cnt < 5)
        {
         uarn_cnt ++;
         UartPutChar(0x7b);UartPutChar(0x3c);UartPutChar(0x3c);UartPutChar(0x3c);
         UartPutChar(0x3c);UartPutChar(0x3c);UartPutChar(0x3c);UartPutChar(0x7d);
         uart1_cnt = 0;
         MAP_UtilsDelay(8000000);
         uart1_error_cnt = 0;
         while((uart1_cnt < 10) && (uart1_error_cnt < 30 ))
         	{
         	 //cCharacter[uart1_cnt] =UartGetChar(); 
         	 cCharacter[uart1_cnt] = MAP_UARTCharGetNonBlocking(CONSOLESH);
         	 if((cCharacter[uart1_cnt] >  0) ||  (cCharacter[uart1_cnt] ==  0)) 
         	 	{
         	 		if((uart1_cnt == 0)&&(cCharacter[0] == 0x7b)) 
                                {uart1_cnt = 1;}
         	 		else if(uart1_cnt) {uart1_cnt++;}
         	 		else 
         	 			{
         	 				 uart1_error_cnt ++;
         	 				 MAP_UtilsDelay(800000);
         	 			}
         	 	}
         	 else 
            {uart1_cnt = 18;cCharacter[0] = 0;}
          }
          //ж϶ǲȷ    0x7b  0x3d 00 002ֽڵĳʱ0-65535ӣ00 002ֽڵʣʱ0-65535ӣ00λ-0 1ߣ00-0 1 00¶ȣ100 0x7d
          uart1_cnt = 0;
          if((cCharacter[0] != 0x7b) ||(cCharacter[9] != 0x7d)||\
          	(cCharacter[1] != 0x3d)||\
          	(cCharacter[6] > 1) ||\
          	(cCharacter[7] > 1) ||(cCharacter[8] > 100))
          	{uart1_cnt = 20 ;}
         if(uart1_cnt > 10)   //ûзȷ
         	{
         		if(shstatus_bit == 11){sh_sucfail = 0;}
         			uart1_err_cnt++;
         			sh_set_power = 0; sh_set_onoff = 0;
         	}
         	else
         		{
         			uart1_err_cnt = 30;sh_sucfail = 1;
         			sh_work_continuetime = ((cCharacter[2] << 8) | cCharacter[3]);
         			sh_surplustime = ((cCharacter[4] << 8) | cCharacter[5]);
         			sh_set_power = cCharacter[6]+1;
         			if(cCharacter[7] == 0){sh_set_onoff = 2;}
                                else{sh_set_onoff = 1;}
         			sh_work_temp = cCharacter[8];  
         			recib_cnt ++;   
         			 UART_PRINT("\r\nRead data send is:%x,%x,%x,%x,%x,%x,%x,%x",\
         		   0x7b,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x7d); 
         		   UART_PRINT("\r\nRead data receive is:%x,%x,%x,%x,%x,%x,%x,%x,%x,%x",\
         		   cCharacter[0],cCharacter[1],cCharacter[2],cCharacter[3],\
         		   cCharacter[4],cCharacter[5],cCharacter[6],cCharacter[7],\
         		   cCharacter[8],cCharacter[9]);  			
         		}
        }			   
			   uart1_2s_cnt = 0;uart1_flag = 0;
       
			   //ΪappԼӵļ״̬ȥ
			 //  sh_work_continuetime = 200; sh_surplustime = 20;sh_work_temp = 20;
			   break;
		
		case control_device:        //豸7b 3f 00 00(2ֽ¶)00λ00״̬00 7d
			  while(uart1_err_cnt < 5)
        {
        	uarn_cnt ++;
         UartPutChar(0x7b);UartPutChar(0x3f);UartPutChar((sh_set_time & 0xff00) >> 8 );UartPutChar((sh_set_time & 0x00ff));
         UartPutChar(sh_set_power-1);
         if(control_bit_sh == 1){UartPutChar(0);}
         else if(sh_set_onoff == 2){UartPutChar(0);}
         else {UartPutChar(1);}
         UartPutChar(0x00);UartPutChar(0x7d);
         MAP_UtilsDelay(8000000);
         uart1_cnt = 0; 
         uart1_error_cnt = 0;
         while((uart1_cnt < 8) && (uart1_error_cnt < 30 ))
         	{
         	 cCharacter[uart1_cnt] =  MAP_UARTCharGetNonBlocking(CONSOLESH);
         	 if((cCharacter[uart1_cnt] >  0) ||  (cCharacter[uart1_cnt] ==  0))
         	 	{
         	 		if((uart1_cnt == 0)&&(cCharacter[0] == 0x7b)) 
                                {uart1_cnt = 1;}
         	 		else if(uart1_cnt) {uart1_cnt++;}
         	 		else 
         	 			{
         	 				 uart1_error_cnt ++;
         	 				 MAP_UtilsDelay(800000);
         	 			}
         	 	}
         	 else 
            {uart1_cnt = 18;cCharacter[0] = 0;}
          }
         for(uart1_cnt = 0;uart1_cnt < 8;uart1_cnt ++)
         {
         	if(cCharacter[uart1_cnt] != com_data_control[uart1_cnt]){uart1_cnt = 20;}
         }
         if(uart1_cnt > 10)   //ûзȷ
         	{
         		if(shstatus_bit == 13){sh_sucfail = 0;}
         			 uart1_err_cnt++;
         			 UART_PRINT("\r\nuart1_err_cnt is:%x",uart1_err_cnt);
         			  UART_PRINT("\r\nControl receive failed is:%x,%x,%x,%x,%x,%x,%x,%x",\
         		   cCharacter[0],cCharacter[1],cCharacter[2],cCharacter[3],\
         		   cCharacter[4],cCharacter[5],cCharacter[6],cCharacter[7]);
         	}
         	else{
         		   uart1_err_cnt = 30;sh_sucfail = 1;	recib_cnt ++;
         		   UART_PRINT("\r\nControl send is:%x,%x,%x,%x,%x,%x,%x,%x",\
         		   0x7b,0x3f,(sh_set_time & 0xff00) >> 8,sh_set_time & 0x00ff,\
         		   sh_set_power-1,sh_set_onoff,0,0x7d);
         		   UART_PRINT("\r\nControl receive is:%x,%x,%x,%x,%x,%x,%x,%x",\
         		   cCharacter[0],cCharacter[1],cCharacter[2],cCharacter[3],\
         		   cCharacter[4],cCharacter[5],cCharacter[6],cCharacter[7]);
         		  }     
        }
        uart1_2s_cnt = 0;uart1_flag = 0;control_bit_sh = 0;
			 break;
	}
	
}
//////////////////////////socketͨѶ//////////////
int WuartTransfer(unsigned long ulBase, int iSockID)
{
	char      cRxBuf[100];
	int       iStatus; 
	int       iCounter = 0;

 while((tcperror_cnt < 4) && (shstatus_bit != 24)
	 {  
	   // UART ַ
	   //MAP_UtilsDelay(8000000);
	   if(work_send_flag == 2)
	   	{
	   		shuart1_control(read_device_status);   //ԺӦݴռ
	   		if((sh_set_time != sh_set_timecp ) || (sh_set_powercp != sh_set_power) || \
     	 							(sh_set_onoff != sh_set_onoffcp ) ||(sh_work_tempcp != sh_work_temp ) ||\
     	 							(sh_work_continuetimecp != sh_work_continuetime ) ||(sh_surplustimecp != sh_surplustime ) )
     	 						{work_send_flag = 3;}//·һ豸
     	 	else {work_send_flag = 1;work_send_1m = 0;}
	   	}
	   	if((work_send_flag == 3)&&((shstatus_bit == 12) ||\
     	 					(shstatus_bit == 14) ||(shstatus_bit == 18) ||\
     	 					(shstatus_bit == 22)))
     	 					{
     	 						shstatus_bit = 15; work_send_flag = 0;
     	 					}
	   if((ap_sta_flag == 1) || (ap_sta_flag == 2))
	   {	
	   	ASSERT_ON_ERROR(sl_Close(iSockID)); 
	   	UART_PRINT("\n\r wlan is disconnect..... \n\r");
	  	 break;
	   }
	  
	   //ϵshstatus_bit=3ǿûȨûȨֻ͵ȴȨ
	   if((status_system[0] == 0) && (shstatus_bit == 3)){sendrece_flag = 0;}   //ûȨȴȨ
	   else   //ѾȨ
	   {
	   	 //ȨֻAPģʽЧյȨAPģʽ,ô
	   	 if(shstatus_bit == 10)   // Ȩ дɹҪ豸
	      	{shstatus_bit = 3;} 
	     else if(shstatus_bit == 6)   //豸ϣҪϴ豸
	      	{shstatus_bit = 15;}
	     //3 15 19Ϊ豸ͣ7 9 11 13 23ΪܣҪӦ÷ͱ־
	     if((shstatus_bit == 3) || (shstatus_bit == 15) || (shstatus_bit == 23) ||\
	     	  (shstatus_bit == 7) || (shstatus_bit == 9) || (shstatus_bit == 11) ||(shstatus_bit == 13))
	     	 {sendrece_flag = 2;}
	   }
	   if (shstatus_bit == 19){sendrece_flag = 2;}
	   ////////////////////////////////////////////////
	   if (sendrece_flag == 2)   //sendrece_flag
	   {
	     
	      if((shstatus_bit == 11) || (shstatus_bit == 15))  //Ƿ豸״̬ȶ豸״̬
	      	{
	      		shuart1_control(read_device_status);   //ԺӦݴռ
	      	}
	     // else if(shstatus_bit == 13)
	     // 	{
	     // 		shuart1_control(control_device);      //豸豸Ƿɹı־
	     //  	}
	      if(shstatus_bit == 23)
	      	{
	      		shsend_tcpsocket(id_homepage,1);
	      		UART_PRINT("\r\n Now message:id_homepage \n\r");
	      	}
	      else if(shstatus_bit == 3)   //豸ѰӻȨ дɹҪ豸
	      	{
	      		shsend_tcpsocket(id_connectequipment,1);
	      		UART_PRINT("\r\n Now message:id_connectequipment \n\r");
	      	}
	      else if(shstatus_bit == 7)   //ȨӦ
	      	{//GPIO_IF_LedOff(MCU_GREEN_LED_GPIO);
	      		shsend_tcpsocket(id_authorize,1);
	      		work_send_flag = 0;work_send_1m = 0;
	      		UART_PRINT("\r\n Now message:id_authorize \n\r");}
	      else if(shstatus_bit == 9)   //ȨдɹӦ
	      	{shsend_tcpsocket(id_authorization,1);
	      		UART_PRINT("\r\n Now message:id_authorization \n\r");}
	      else if(shstatus_bit == 11)   //ˢӦ
	      	{shsend_tcpsocket(id_refreshdata,1);
	      		UART_PRINT("\r\n Now message:\r\n Now message:id_refreshdata \n\r");}
	      else if(shstatus_bit == 13)   //ؿ豸Ӧ-
	      	{shsend_tcpsocket(id_controlwork,sh_sucfail);
	      	 UART_PRINT("\r\n Now message:id_controlwork \n\r");}
	     else if(shstatus_bit == 15)   //豸ϣҪϴ豸
	      	{ 
	      		shsend_tcpsocket(id_workdata,1);
	      		UART_PRINT("\r\n Now message:id_workdata \n\r");}
	      else if(shstatus_bit == 19)   //
	      	{shsend_tcpsocket(id_heartbeat,1);
	      		UART_PRINT("\r\n Now message:id_heartbeat \n\r");}
	      
	     
         
	      //TCP
	      print_dataarray(tcp_sr_buffer,send_resive_cnt,0);
	      iStatus = sl_Send(iSockID, tcp_sr_buffer, send_resive_cnt, 0);
	      if(iStatus < 0)
	      {
	       sendrece_flag = 5;             //ʧܱ־
	       tcperror_cnt = 4;
	       //
	       ASSERT_ON_ERROR(sl_Close(iSockID)); 
	       UART_PRINT("send data faile 1 \n\r");
	       break;
	      }
	      else 
	      {
	      	heartbeat_11s = 0;
	      	count_send++;
       	  shstatus_bit++;	        
	      	sendrece_flag = 4;             //ͳɹ־ 
	      	shsta_bitcopy = shstatus_bit; 
	       	if((shstatus_bit ==4) || (shstatus_bit ==16) ||(shstatus_bit ==20))
	      	{	//ô־3ûյظ·ͣ3κ󱨴
	      		three_seconds = 0;tcperror_cnt ++;
	      		//ʱʱ600ms
	      		//MAP_UtilsDelay(8000000); MAP_UtilsDelay(8000000);  
	      	}  
  	       //ִй豸ˢ豸豸ϸһαݣ1ٴβѯ
        	if((shstatus_bit == 12)||(shstatus_bit == 14))
     		    {
     		   		work_send_flag = 1;work_send_1m = 0;
     		   		if(shstatus_bit == 12)
     		  		{
     		  		 sh_set_timecp = sh_set_time;sh_set_powercp = sh_set_power;
     	 				 sh_set_onoffcp =sh_set_onoff;sh_work_tempcp = sh_work_temp;
     	 				 sh_work_continuetimecp = sh_work_continuetime;
     	 				 sh_surplustimecp = sh_surplustime;
     	 				}
     		     }		
	    		UART_PRINT("\r\nfasong zongshu =%d ",count_send);
	    		if(uart1_err_cnt == 5)  //3ξͲ忴ǹˣֱӸλ
     	 	   {err_loop_flag = 1;}
     	 	  home_cnt_10s = 0;
	      }
	   }
	    if(uart1_err_cnt == 5)
	   	{
	   		ASSERT_ON_ERROR(sl_Close(iSockID)); 
	   	  UART_PRINT("\n\rShuart1 is failed..... \n\r");
	  	  break;
	   	}
	   //TCP ݰ
	   //char,ݱ벻ܰ0'\0'ݺ'\0'
	   //Ϳstrlenĳˡ
	   //豸͵ûеõȷĴ𸴣򲻽գȴ豸3·
	  if((shstatus_bit != 5) && (shstatus_bit != 17) && (shstatus_bit != 21))
	  {
	   iCounter = 0;
	   while( iCounter < 50)
	   { 
	   memset(cRxBuf,'\0',sizeof(cRxBuf));

	   iStatus = sl_Recv(iSockID, cRxBuf, 4, 0);
	       if((iStatus > 0) && (cRxBuf[0] == 'S') && (cRxBuf[1] == 'H') && (cRxBuf[2] == 'P') && (cRxBuf[3] == 'C'))
          {
             MAP_UtilsDelay(5300000);  //ʱ400ms
             iCounter = 0;
            
             while( iCounter <50)
              {	
             			iStatus = sl_Recv(iSockID, &cRxBuf[4], 4, 0);
             			if(iStatus > 0)
             		 { 	
             		 	iCounter = 0;
             		  while( iCounter <50)
             		 {
             			iStatus = sl_Recv(iSockID, &cRxBuf[8], cRxBuf[7], 0);
             			if(iStatus > 0)
             			{
	    		          analysis_data(cRxBuf);
	    		          //ܵݲҪݣ11sʱ־ýܳɹλ
	    		          if((senddata_isnot_my == 0)&&((shstatus_bit == 6)||(shstatus_bit == 7)||(shstatus_bit == 9)\
	    		          	||(shstatus_bit == 11)||(shstatus_bit == 13)||(shstatus_bit == 18)\
	    		          	||(shstatus_bit == 22)||(shstatus_bit == 23)))
	    		          	{	    		          		             			            			         			 
	    		          		
	    		          			jieshou_shpc_cnt++;
             			     	  UART_PRINT("\r\nRecevie_shpc_cnt zongshu =%d\n\r",jieshou_shpc_cnt); 
             			      	print_dataarray(cRxBuf,(cRxBuf[7]+8),1);    
	    		          	  	sendrece_flag = 3;//յȷ
	    		              	heartbeat_11s = 0;    		              	
	    		              	if(shstatus_bit == 18)
     	                      {
     		   										work_send_flag = 1;work_send_1m = 0;
     		  										sh_set_timecp = sh_set_time;sh_set_powercp = sh_set_power;
     	 												sh_set_onoffcp =sh_set_onoff;sh_work_tempcp = sh_work_temp;
     	 												sh_work_continuetimecp =sh_work_continuetime;
     	 												sh_surplustimecp = sh_surplustime;
     												}		
     											 else if(shstatus_bit == 13)   //ؿ豸Ӧ--ɷʹĵΪ˷ֹû豸Ͷ豸Ϣ޸˿ڿȥ
	      										{
	      											shuart1_control(control_device);      //豸豸Ƿɹı־
	      		                  UART_PRINT("\r\n Now message:id_controlwork and uart1 send! \n\r");}
	    		            }
	    		           else if(senddata_isnot_my == 2) {UART_PRINT("\r\nReceive data ======= last data!!!\n\r");}
	    		           else if(senddata_isnot_my == 3) {UART_PRINT("\r\nReceive data is don't do,it isn't allow !!!\n\r");}
	    		           else{UART_PRINT("\r\nRecevie data is false!!!\n\r");}
                     print_dataarray(cRxBuf,(cRxBuf[7]+8),1); 
	    		          iCounter = 50;
             			}
             			else 
             			{
             				iCounter++;
                  	MAP_UtilsDelay(800000);  // 60ms   
             			}
             		 }
             		 }
             		 else 
             			{
             				iCounter++;
                  	MAP_UtilsDelay(800000);  // 60ms         				
             			}
             	} 
          } 
        else   
        	{ 
        		if((shstatus_bit != 4) || (shstatus_bit != 16) ||(shstatus_bit != 20))
        		 {iCounter = 50;} 	 //ûнգת  	
        		else
        		 {
        			 iCounter++;
               MAP_UtilsDelay(800000);  // 60ms 
        		 }
        	}   		  
     }
    }
	 }
	return(iStatus); 
}
//****************************************************************************
//
//! \brief Opening a TCP server side socket and receiving data
//!
//! This function opens a TCP socket in Listen mode and waits for an incoming
//!    TCP connection.
//! If a socket connection is established then the function will try to read
//!    1000 TCP packets from the connected client.
//!
//! \param[in] port number on which the server will be listening on
//!
//! \return     0 on success, -1 on error.
//!
//! \note   This function will wait for an incoming connection till
//!                     one is established
//
//****************************************************************************
int BsdTcpServer(unsigned short usPort)
{
    SlSockAddrIn_t  sAddr;
    SlSockAddrIn_t  sLocalAddr;
    int             iAddrSize;
    int             iSockID;
    int             iStatus;
    int             iNewSockID;
    long            lNonBlocking = 1;
 
    //filling the TCP server socket address
    sLocalAddr.sin_family = SL_AF_INET;
    sLocalAddr.sin_port = sl_Htons((unsigned short)usPort);
    sLocalAddr.sin_addr.s_addr = 0;

    // creating a TCP socket
    //TCP׽
    iSockID = sl_Socket(SL_AF_INET,SL_SOCK_STREAM, 0);
    if( iSockID < 0 )
    {
        // error
        ASSERT_ON_ERROR(TCP_SERVER_FAILED);
        //UART_PRINT("SHUIXY Tcp server failed\n\r");
    }

    iAddrSize = sizeof(SlSockAddrIn_t);

    // binding the TCP socket to the TCP server address
    //TCP׽ְ󶨵TCPַ
    iStatus = sl_Bind(iSockID, (SlSockAddr_t *)&sLocalAddr, iAddrSize);
    if( iStatus < 0 )
    {
        // error
        ASSERT_ON_ERROR(sl_Close(iSockID));
        ASSERT_ON_ERROR(TCP_SERVER_FAILED);
        //UART_PRINT("SHUIXY Tcp server failed\n\r");
    }
    // putting the socket for listening to the incoming TCP connection
    //TCPӵ׽
    iStatus = sl_Listen(iSockID, 0);
    if( iStatus < 0 )
    {
        ASSERT_ON_ERROR(sl_Close(iSockID));
        ASSERT_ON_ERROR(TCP_SERVER_FAILED);
       //UART_PRINT("SHUIXY Tcp server failed\n\r");
    }

    // setting socket option to make the socket as non blocking
    //׽ѡΪ׽
    iStatus = sl_SetSockOpt(iSockID, SL_SOL_SOCKET, SL_SO_NONBLOCKING, 
                            &lNonBlocking, sizeof(lNonBlocking));
    if( iStatus < 0 )
    {
        ASSERT_ON_ERROR(sl_Close(iSockID));
        ASSERT_ON_ERROR(TCP_SERVER_FAILED);
    }
    UART_PRINT("\r\nTCp socket server waiting client required connect...... \n\r");
    iNewSockID = SL_EAGAIN;

    // waiting for an incoming TCP connection
    //sl_Accept Ϊsl_SetSockOptΪģʽѭʽʵ
    while( iNewSockID < 0 )
    {
        // accepts a connection form a TCP client, if there is any
        // otherwise returns SL_EAGAIN
        iNewSockID = sl_Accept(iSockID, ( struct SlSockAddr_t *)&sAddr, 
                                (SlSocklen_t*)&iAddrSize);
        if( iNewSockID == SL_EAGAIN ) //Ϊ
        {
           MAP_UtilsDelay(10000);
        }
        else if( iNewSockID < 0 )
        {
            // error ASSERT_ON_ERROR(sl_Close(iNewSockID));
             if( sl_Close(iNewSockID) < 0 )
    	        {UART_PRINT("tcp client is quit, iNewSockID isn't creat!\n\r");} 
    	        // ASSERT_ON_ERROR(sl_Close(iSockID));
    	       ASSERT_ON_ERROR(sl_Close(iSockID));
             ASSERT_ON_ERROR(TCP_SERVER_FAILED);
        }
        if( ap_sta_flag == 1)   //ͻѾˣٵȴsocketˣҪµȴͻ
        	{
        		 if( sl_Close(iNewSockID) < 0 )
    	        {UART_PRINT("tcp client is quit, iNewSockID isn't creat!\n\r");}          
        		 ASSERT_ON_ERROR(sl_Close(iSockID));
             ASSERT_ON_ERROR(TCP_SERVER_FAILED);
        	}
        
    }
   UART_PRINT("\r\nTcp  client is connect to my SH(TCP server) ok! YOU can send and receive data now!\n\r");
   
   //Ϊģʽ
     iStatus = sl_SetSockOpt(iNewSockID, SL_SOL_SOCKET, SL_SO_NONBLOCKING, 
                            &lNonBlocking, sizeof(lNonBlocking));
    if( iStatus < 0 )
    {
        if( sl_Close(iNewSockID) < 0 )
    	     {UART_PRINT("tcp client is quit, iNewSockID isn't creat!\n\r");}
        ASSERT_ON_ERROR(sl_Close(iSockID));
        UART_PRINT("SHUIXY Tcp server failed\n\r");
    }
    ap_ext = 0;
    shstatus_bit = 3;//socket 
    if (authoreze_flag == 1){ status_system[0] = 0;}//Ȩ
    tcperror_cnt = 0 ;sendrece_flag = 0;
    sh_set_timecp = 0;sh_set_time = 0;sh_set_powercp = 0;sh_set_power = 2;
    sh_set_onoffcp = 0;sh_set_onoff = 2;sh_work_tempcp = sh_work_temp = 0;
    sh_work_continuetimecp = sh_work_continuetime = 0;
    sh_surplustimecp = sh_surplustime = 0;
    test_data = 1;control_bit_sh = 0;No_accept_ok = 0;uart1_err_cnt = 0;
    uart1_2s_cnt = 0;uart1_flag = 0;work_send_flag = 0;work_send_1m = 0;
    home_cnt_10s = 0;
    err_loop_flag = 0;
     MAP_UtilsDelay(8000000);        //ʱ0.6s
    temp_jishucnt ++;
    //UART
    iStatus = WuartTransfer(UARTA0_BASE,iNewSockID);
    if(iStatus < 0)
    	{
    		UART_PRINT("WUART Transfer failed and waitting tcp client again\n\r");
    	}
    //  ASSERT_ON_ERROR(sl_Close(iNewSockID));
  if( sl_Close(iNewSockID) < 0 )
    	{UART_PRINT("tcp client is quit, close now sockId error!.......%d\n\r",temp_jishucnt);}
   //  1186ִд󣬾ִв1189ΪѾ1186˳1189ǹرsocket
    // close the listening socket
    ASSERT_ON_ERROR(sl_Close(iSockID));  
    ap_ext = 1;
    UART_PRINT("\r\nExiting Application normal...%d\n\r",temp_jishucnt);
    return SUCCESS;
}

//****************************************************************************
//
//! \brief Opening a TCP client side socket and sending data
//!
//! This function opens a TCP socket and tries to connect to a Server IP_ADDR
//!    waiting on port PORT_NUM.
//!    If the socket connection is successful then the function will send 1000
//! TCP packets to the server.
//!
//! \param[in]      port number on which the server will be listening on
//!
//! \return    0 on success, -1 on Error.
//
//****************************************************************************
int BsdTcpClient(unsigned short usPort)
{
   // int             iCounter;
   // short           sTestBufLen;
    SlSockAddrIn_t  sAddr;
    int             iAddrSize;
    int             iSockID;
    int             iStatus;
     //filling the TCP server socket address
    sAddr.sin_family = SL_AF_INET;
    sAddr.sin_port = sl_Htons((unsigned short)usPort);
    //sAddr.sin_addr.s_addr = sl_Htonl((unsigned int)g_ulDestinationIp);
    sAddr.sin_addr.s_addr = sl_Htonl((unsigned int)IP_ADDR);
    iAddrSize = sizeof(SlSockAddrIn_t);
    UART_PRINT("Creat tcp client socket  and connect to server socket.............\n\r");
    // creating a TCP socket
    iSockID = sl_Socket(SL_AF_INET,SL_SOCK_STREAM, 0);
    if( iSockID < 0 )
    {
        UART_PRINT("TCP Client failed1\n\r");
        ASSERT_ON_ERROR(TCP_CLIENT_FAILED);
         
    }

    // connecting to TCP server
    iStatus = sl_Connect(iSockID, ( SlSockAddr_t *)&sAddr, iAddrSize);
    if( iStatus < 0 )
    {
        // error
        ASSERT_ON_ERROR(sl_Close(iSockID));
        UART_PRINT("TCP Client failed2\n\r");
        ASSERT_ON_ERROR(TCP_CLIENT_FAILED);
         
    }

//Ϊģʽ
    long lNonBlocking = 1;
    iStatus = sl_SetSockOpt(iSockID,SL_SOL_SOCKET,SL_SO_NONBLOCKING,&lNonBlocking,sizeof(lNonBlocking));
    if(iStatus < 0)
    	{
    		ASSERT_ON_ERROR(sl_Close(iSockID));
    		UART_PRINT("TCP Client failed3\n\r");
    		ASSERT_ON_ERROR(TCP_CLIENT_FAILED);
    	}
    UART_PRINT("Tcp client socket is connet to server socket ok!Can send and receive data now!\n\r");
    shstatus_bit = 3;//socket
    tcperror_cnt = 0 ;
    work_send_flag = 0;work_send_1m = 0;
    sh_set_timecp = 0;sh_set_time = 0;sh_set_powercp = 0;sh_set_power = 2;
    sh_set_onoffcp = 0;sh_set_onoff = 2;sh_work_tempcp = sh_work_temp = 0;
    sh_work_continuetimecp = sh_work_continuetime = 0;
    sh_surplustimecp = sh_surplustime = 0;
    test_data = 1;control_bit_sh = 0;No_accept_ok = 0;uart1_err_cnt = 0;
    uart1_2s_cnt = 0;uart1_flag = 0;home_cnt_10s = 0;err_loop_flag=0;
    //UART
    iStatus = WuartTransfer(UARTA0_BASE,iSockID);
    if(iStatus < 0)
    	{
    		UART_PRINT("WUART Transfer failed\n\r");
    	}
    UART_PRINT("\r\nExiting Application ...\n\r");
    //closing the socket after sending 1000 packets
    ASSERT_ON_ERROR(sl_Close(iSockID));

    return SUCCESS;
}

//****************************************************************************
//
//! \brief Start simplelink, connect to the ap and run the ping test
//!
//! This function starts the simplelink, connect to the ap and start the ping
//! test on the default gateway for the ap
//!
//! \param[in]  pvParameters - Pointer to the list of parameters that 
//!             can bepassed to the task while creating it
//!
//! \return  None
//
//****************************************************************************
//void WlanStationMode( void *pvParameters )
void WlanStationMode( )
{
  // while (1)
  // {
    long lRetVal = -1;
 
    lRetVal = sl_Start(0, 0, 0);
    if (lRetVal < 0 || ROLE_STA != lRetVal)
    {
        UART_PRINT("Failed to start the device \n\r");
        err_loop_flag = 1;
        LOOP_FOREVER();
    }

    UART_PRINT("Device started as STATION \n\r");
    err_wait5s_flag = 3;err_wait5s_cnt = 0 ;
   /* Connect to our AP using SmartConfig method */
   lRetVal = SmartConfigConnect();
   if(lRetVal < 0)
   { 
     ERR_PRINT(lRetVal);
   }   
   shstatus_bit = 1;  error_cnt = 0;     //豸
   while(ap_sta_flag != 2)   //ûϣֻsocketϵʱظ
   {
      shstatus_bit = 1;       //豸      
      lRetVal = BsdTcpClient(5581); 
      if(lRetVal < 0)
    	 {
    	  	UART_PRINT("TCPServer failed: Disconnect or data failed.waiting connect socket server again\n\r");
    	 	  error_cnt ++ ;
   			}
   	 MAP_UtilsDelay(8000000); //600msʱ
   	 if (error_cnt > 4)
   	 	{ap_sta_flag = 2;}
    	 
    //
   }
   if(ap_sta_flag == 2)   //
   	{UART_PRINT(" The AP is Disconnect,wait connect AP and TCP socket server........\n\r");}
   ap_sta_flag = 0;    //λжϱ־
    // power off the network processor
    //
    lRetVal = sl_Stop(SL_STOP_TIMEOUT);
    UART_PRINT("Application  exits\n\r");
    MAP_UtilsDelay(8000000);        //ʱ0.6s
 // }
}
//****************************************************************************
//
//!    \brief start simplelink, wait for the sta to connect to the device and 
//!        run the ping test for that sta
//!
//!    \param  pvparameters is the pointer to the list of parameters that can be
//!         passed to the task while creating it
//!
//!    \return None
//
//****************************************************************************
//void WlanAPMode( void *pvParameters )
void WlanAPMode( ) 
{   
  //error_cnt = 0; 
 // while(error_cnt < 2 )
 // {
   // int iTestResult = 0;
    unsigned char ucDHCP;
    long lRetVal = -1;
    ap_ext = 0;ap_clienton = 0;
   	UART_PRINT("GO to set  Ap mode................! \n\r");
    lRetVal = sl_Start(NULL,NULL,NULL);

    if (lRetVal < 0)
    {
        UART_PRINT("Failed to start the device \n\r");
        err_loop_flag = 1;
        LOOP_FOREVER();
    }

    UART_PRINT("Device started as STATION \n\r");
    
    //
    // Configure the networking mode and ssid name(for AP mode)
    //
    if(lRetVal != ROLE_AP)
    {
        if(ConfigureMode(lRetVal) != ROLE_AP)
        {
            UART_PRINT("Unable to set AP mode, exiting Application...\n\r");
            sl_Stop(SL_STOP_TIMEOUT);
            err_loop_flag = 1;
            LOOP_FOREVER();
        }
    }
    err_wait5s_flag = 3;

    while(!IS_IP_ACQUIRED(g_ulStatus))
    {
      //looping till ip is acquired
    }

    unsigned char len = sizeof(SlNetCfgIpV4Args_t);
    SlNetCfgIpV4Args_t ipV4 = {0};

    // get network configuration
    lRetVal = sl_NetCfgGet(SL_IPV4_AP_P2P_GO_GET_INFO,&ucDHCP,&len,
                            (unsigned char *)&ipV4);
    if (lRetVal < 0)
    {
        UART_PRINT("Failed to get network configuration \n\r");
        err_loop_flag = 1;
        LOOP_FOREVER();
    }
    
     
    UART_PRINT("Wait connect a client to Device:SH......\n\r");

    while(!IS_IP_LEASED(g_ulStatus))
    {
      //wating for the client to connect
    }
    UART_PRINT("Client is connected to Device\n\r");   //Ѿпͻӵ豸ʱ豸Ƿ
    ap_sta_flag = 0;  error_cnt = 0;   //λжϱ־ 
    ap_clienton = 1; ap_socketcnt = 0;
    while(ap_sta_flag != 1)    //ͻûжֻsocketˣظ
    {
    	shstatus_bit = 1;       //豸
    	//TCPģʽ
    	lRetVal = BsdTcpServer(5581);
    	if(lRetVal < 0)
    		{
      		UART_PRINT("SHUIXY Tcp socket server failed,creating tcp socket server and waitting client again\n\r");
   			 if(lRetVal == TCP_SERVER_FAILED)
   			 	 {error_cnt ++ ;
   			 	   // Switch off Network processor
           //lRetVal = sl_Stop(SL_STOP_TIMEOUT);
          lRetVal = sl_Start(NULL,NULL,NULL);
          }
   			}
   	 MAP_UtilsDelay(8000000); //600msʱ
   	 MAP_UtilsDelay(8000000); 
   	// 20160312-1ȥΪֻԶwifiAP
   	//-2ȥsocketһֱѭ󣬾һֱˣȥ
   	if (error_cnt > 10)  //
   	 	{ap_sta_flag = 1;}
   }
   if( ap_sta_flag == 1)     
    	{
    		ap_sta_flag = 0;
    		UART_PRINT("\r\n client is disconnect from AP------OPEN_ZL-----,waitting client again............\n\r");
    	}
   else
   {UART_PRINT("\r\n AP success  Application exits next .........\n\r");}
//  }
    // revert to STA mode 
    lRetVal = sl_WlanSetMode(ROLE_STA);
    if(lRetVal < 0)
    {
      ERR_PRINT(lRetVal);
      err_loop_flag = 1;
      LOOP_FOREVER();
    }

    // Switch off Network processor
    lRetVal = sl_Stop(SL_STOP_TIMEOUT);
    
    UART_PRINT(" SHUIXY AP MODE Application exits\n\r");
//  }
 
}

//*****************************************************************************
//
//! Application startup display on UART
//!
//! \param  none
//!
//! \return none
//!
//*****************************************************************************
static void
DisplayBanner(char * AppName)
{
    Report("\n\n\n\r");
    Report("\t\t *************************************************\n\r");
    Report("\t\t       CC3200 %s Application       \n\r", AppName);
    Report("\t\t *************************************************\n\r");
    Report("\n\n\n\r");
}

//*****************************************************************************
//
//! Board Initialization & Configuration
//!
//! \param  None
//!
//! \return None
//
//*****************************************************************************
static void
BoardInit(void)
{
/* In case of TI-RTOS vector table is initialize by OS itself */
#ifndef USE_TIRTOS
    //
    // Set vector table base
    //
#if defined(ccs) || defined(gcc)
    MAP_IntVTableBaseSet((unsigned long)&g_pfnVectors[0]);
#endif
#if defined(ewarm)
    MAP_IntVTableBaseSet((unsigned long)&__vector_table);
#endif
#endif
    //
    // Enable Processor
    //
    MAP_IntMasterEnable();
    MAP_IntEnable(FAULT_SYSTICK);

    PRCMCC3200MCUInit();
}
//ǲѾȨѡģʽ
void WlanAPStaMode( void *pvParameters )
{
	 stalink_errcnt = 0;
	 while (1)
   {
    long lRetVal = -1;
    InitializeAppVariables();

    //
    // Following function configure the device to default state by cleaning
    // the persistent settings stored in NVMEM (viz. connection profiles &
    // policies, power policy etc)
    //
    // Applications may choose to skip this step if the developer is sure
    // that the device is in its default state at start of applicaton
    //
    // Note that all profiles and persistent settings that were done on the
    // device will be lost
    //
   while(lRetVal < 0) 
   {
     lRetVal = ConfigureSimpleLinkToDefaultState();
      if(lRetVal < 0)
      {
        if (DEVICE_NOT_IN_STATION_MODE == lRetVal)
        {
            UART_PRINT("Failed to configure the device in its default state\n\r");
        }
       MAP_UtilsDelay(8000000); //0.6S
      }
    }
    UART_PRINT("Device is configured in default state \n\r");
    key_press_cnt = 21;
    if(key_press_cnt < 20)
    	{WlanStationMode();}
     else 
     {WlanAPMode();}    
  }
}

//*****************************************************************************
//                            MAIN FUNCTION
//*****************************************************************************
void main()
{
   long lRetVal = -1;
   tBoolean bRetcode;
   unsigned long ulResetCause;
   unsigned char wdt_rest_fig = 0;
    //
    // Board Initialization
    //
    BoardInit();
    
    //
    // Configure the pinmux settings for the peripherals exercised
    //
    PinMuxConfig();
    
#ifndef NOTERM
    //
    // Configuring UART
    //
    InitTerm();
#endif
    //SHInitTerm();
     MAP_UARTConfigSetExpClk(CONSOLESH,MAP_PRCMPeripheralClockGet(CONSOLE_PERIPHSH), 
                  UART_BAUD_RATE, (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE |
                   UART_CONFIG_PAR_NONE));
    err_wait5s_cnt = 0;  err_wait5s_flag = 0; err_loop_flag = 0;uart1_err_cnt = 0;
    uart1_2s_cnt = 0;uart1_flag = 0;
    DisplayBanner(APP_NAME);
    
    GPIO_IF_LedConfigure(LED1|LED2|LED3);
    GPIO_IF_LedOff(MCU_ALL_LED_IND);
   
    //Ź
  /*  ulResetCause = PRCMSysResetCauseGet();
    if( ulResetCause == PRCM_WDT_RESET ) */
    {
      wdt_rest_fig = 1;
      GPIO_IF_LedOn(MCU_RED_LED_GPIO);
       // UART_PRINT("Reset Cause        : Watchdog Reset\n\r");
     MAP_UtilsDelay(12000000);    //һ
     GPIO_IF_LedOff(MCU_RED_LED_GPIO);
     MAP_UtilsDelay(12000000);    //һ
     UART_PRINT("\r\nWatchdog is reset!\n\r");
    }
   // else 
    {
     GPIO_IF_LedOn(MCU_ALL_LED_IND);
     MAP_UtilsDelay(12000000);   //0.3
     GPIO_IF_LedOff(MCU_ALL_LED_IND);
     UART_PRINT("\r\nPOWER is reset!\n\r");
    }
  
    // Base address for first timer
    //
    g_ulBase = TIMERA0_BASE;
    //
    // Base address for second timer
    //
    g_ulRefBase = TIMERA1_BASE;
    //
    // Configuring the timers
    //
    Timer_IF_Init(PRCM_TIMERA0, g_ulBase, TIMER_CFG_PERIODIC, TIMER_A, 0);
    Timer_IF_Init(PRCM_TIMERA1, g_ulRefBase, TIMER_CFG_PERIODIC, TIMER_A, 0);

    //
    // Setup the interrupts for the timer timeouts.
    //
    Timer_IF_IntSetup(g_ulBase, TIMER_A, TimerBaseIntHandler);
    Timer_IF_IntSetup(g_ulRefBase, TIMER_A, TimerRefIntHandler);

    //
    // Turn on the timers
    //
    Timer_IF_Start(g_ulBase, TIMER_A,
                  PERIODIC_TEST_CYCLES * PERIODIC_TEST_LOOPS / 10);   //0.5s
    Timer_IF_Start(g_ulRefBase, TIMER_A,
                  PERIODIC_TEST_CYCLES * PERIODIC_TEST_LOOPS / 20);  // 0.25s
   
     //WDT_IF_Init(WatchdogIntHandler, MILLISECONDS_TO_TICKS(WD_PERIOD_MS));
 /*   WDT_IF_Init(NULL,MILLISECONDS_TO_TICKS(WD_PERIOD_MS));  //1sλ
    
    bRetcode = MAP_WatchdogRunning(WDT_BASE);
    if(!bRetcode)
    {
       WDT_IF_DeInit();
    }
    
    //
    // Loop forever while the LED winks as watchdog interrupts are handled.
    //
     MAP_WatchdogIntClear(WDT_BASE);
   */
  
    while(1)
   { //
    // Display banner
    //
   
    //InitializeAppVariables();
    //
    // Start the SimpleLink Host
    //
    err_wait5s_flag = 2;err_wait5s_cnt = 0 ;
    lRetVal = VStartSimpleLinkSpawnTask(SPAWN_TASK_PRIORITY);
    if(lRetVal < 0)
    {
        ERR_PRINT(lRetVal);
        err_loop_flag = 1;
        LOOP_FOREVER();
    }
    
    
    InitializeAppVariables();
    err_wait5s_flag = 3;
    //
    // Following function configure the device to default state by cleaning
    // the persistent() settings stored in NVMEM (viz. connection profiles() &
    // policies, power policy etc) //洢nvmem־
    //
    // Applications may choose to skip this step if the developer is sure
    // that the device is in its default state at start of applicaton //ȷϿʱ
    //豸Ĭ״̬ⲽ
    //
    // Note that all profiles and persistent settings that were done on the
    // device will be lost
    //  ļ豸ϵĳýʧ
   UART_PRINT("Read KEY_GPIO_03_PIN_58 is 1 or 0......     \n\r");
   if(wdt_rest_fig == 0 )   //Źλģʽ
   	{
   		 shstatus_bit = 2;   //ж϶i/oڱ־
       ReadDeviceConfiguration();
       shstatus_bit = 0;
   	} 
     err_wait5s_flag = 2;err_wait5s_cnt = 0 ;
    lRetVal = osi_TaskCreate( WlanAPStaMode, \
                            (const signed char*)"wireless LAN in AP/STA mode", \
                            OSI_STACK_SIZE, NULL, 1, NULL );
    if(lRetVal < 0)
    {
        ERR_PRINT(lRetVal);
        err_loop_flag = 1;
        LOOP_FOREVER();
    }
  
    // Start the task scheduler
    //
    osi_start();
   

  }
}

//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************
